/////////////////////////////////////////////////////////////////////
//
// http.h, (c) 2015, Ryan A. Colyer
// Distributed under the Boost Software License, v1.0. (LICENSE.txt)
//
/////////////////////////////////////////////////////////////////////


#include "RC/RC.h"

class HTTP {
  protected:
  // Returns connection, /url/location
  static RC::Tuple<RC::Sock, RC::RStr> OpenHTTP(RC::RStr url) {
    using namespace RC;

    size_t respos = url.find("://");
    if (respos == url.npos) {
      Throw_RC_Type(Net, "Invalid resource type");
    }
    RStr restype = url.substr(0,respos);
    u32 port = 80;
    if (restype == "http") {
      port = 80;
    }
    else if (restype == "https") {
      port = 443;
      Throw_RC_Type(Net, "https unsupported");
    }
    else {
      Throw_RC_Type(Net, "Unrecognized resource type");
    }

    size_t start_addr = respos+3;
    size_t end_addr = url.find("/", start_addr);
    RStr addr = url.substr(start_addr, end_addr-start_addr);
    RStr location = "/";

    if (end_addr != url.npos) {
      location = url.substr(end_addr);
    }

    Sock soc;
    Net::Connect(soc, addr, port, false);

    return {soc, location};
  }


  static RC::RStr GetResponse(RC::Sock soc) {
    using namespace RC;

    RStr response;

    while (soc.Recv(response, false) && response.Chomp() == "") { }

    if (response != "HTTP/1.1 200 OK") {
      Throw_RC_Type(Net, "OK response missing");
    }

    Data1D<RStr> lines;
    RStr line;
    while (soc.Recv(line, false)) {
      lines += line;
    }
    
    for (size_t i=0; i<lines.size(); i++) {
      RStr tmp = lines[i];
      if (tmp.Chomp() == "") {
        lines.SetOffset(i+1);
        break;
      }
    }

    RStr retdata = RStr::Join(lines);

    return retdata;
  }


  public:
  // Quick and dirty routine to execute a Put.
  static RC::RStr Put(RC::RStr url, RC::RStr putdata) {
    using namespace RC;

    Sock soc;
    RStr location;
    OpenHTTP(url).Get(soc, location);

    RStr command = "PUT " + location + " HTTP/1.1\r\n"
                 + "User-Agent: HTTPLib/0.1\r\n"
                 + "Accept */*\r\n"
                 + "Transfer-Encoding: chunked\r\n"
                 + "Expect: 100-continue\r\n\r\n";
    soc.Send(command);

    RStr response;

    if (soc.Recv(response) == 0 ||
        (response != "HTTP/1.1 100 Continue")) {
      Throw_RC_Type(Net, "Continue response missing");
    }

    RStr submit = RStr(putdata.size(), HEX, 1) + "\r\n" + putdata;

    soc.Send(submit);

    soc.Send(RStr("0\r\n\r\n"));

    return GetResponse(soc);
  }

  // Quick and dirty routine to execute a Post.
  static RC::RStr Post(RC::RStr url, RC::RStr postdata) {
    using namespace RC;

    Sock soc;
    RStr location;
    OpenHTTP(url).Get(soc, location);

    RStr command = "POST " + location + " HTTP/1.1\r\n"
                 + "User-Agent: HTTPLib/0.1\r\n"
                 + "Accept */*\r\n"
                 + "Content-Length: " + postdata.size() + "\r\n"
                 + "\r\n"
                 + postdata;

    soc.Send(command);

    return GetResponse(soc);
  }
};

